<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1, shrink-to-fit=no">
    <meta name="description" content="Bahria Active">
    <meta name="author" content="Taha Khurram">
    <link href="https://fonts.googleapis.com/css?family=Poppins:100,100i,200,200i,300,300i,400,400i,500,500i,600,600i,700,700i,800,800i,900,900i&display=swap"
          rel="stylesheet">

    <title>Bahria Active</title>

    <!-- Additional CSS Files -->
    <link rel="stylesheet" type="text/css" href="assets/css/bootstrap.min.css">

    <link rel="stylesheet" type="text/css" href="assets/css/font-awesome.css">

    <script src="https://ajax.googleapis.com/ajax/libs/jquery/2.1.1/jquery.min.js"></script>

    <link rel="stylesheet" href="assets/css/default.css">

    <link rel="stylesheet" href="assets/css/custom.css">
    
    <!-- ===== Link Swiper's CSS ===== -->
    <link rel="stylesheet" href="assets/css/swiper-bundle.min.css"/>

    <!-- ===== Fontawesome CDN Link ===== -->
    <link rel="stylesheet" href="assets/css/font-awesome6.0.css"/>

    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" fill="currentColor" class="bi bi-facebook" viewBox="0 0 16 16">
  <path d="M16 8.049c0-4.446-3.582-8.05-8-8.05C3.58 0-.002 3.603-.002 8.05c0 4.017 2.926 7.347 6.75 7.951v-5.625h-2.03V8.05H6.75V6.275c0-2.017 1.195-3.131 3.022-3.131.876 0 1.791.157 1.791.157v1.98h-1.009c-.993 0-1.303.621-1.303 1.258v1.51h2.218l-.354 2.326H9.25V16c3.824-.604 6.75-3.934 6.75-7.951z"/>
</svg>

    <link rel="icon" type="image/png" href="images/icons/favicon.png"/>
</head>

<body>

<!-- ***** Preloader Start ***** -->
<!--<div id="js-preloader" class="js-preloader">-->
<!--    <div class="preloader-inner">-->
<!--        <span class="dot"></span>-->
<!--        <div class="dots">-->
<!--            <img alt="loader" src="images/loader.png">-->
<!--            <span></span>-->
<!--            <span></span>-->
<!--            <span></span> -->
<!--        </div>-->
<!--    </div>-->
<!--</div>-->
<!-- ***** Preloader End ***** -->


<!-- ***** Header Area Start ***** -->
<header class="header-area header-sticky">
    <div class="container">
        <div class="row">
            <div class="col-12">
                <nav class="main-nav">
                    <!-- ***** Logo Start ***** -->
                    <!--                    <a href="index.html" class="logo">Bahria<em> Active</em></a>-->
                    <div class="logo">
                        <img alt="cmp-logo" style="width: 200px" src="images/companylogo1.png">
                    </div>
                    <!-- ***** Logo End ***** -->
                    <!-- ***** Menu Start ***** -->
                    <ul class="nav">
                        <li class="scroll-to-section"><a href="#top" class="active">Home</a></li>
                        <li class="scroll-to-section"><a href="#services">Services</a></li>
                        <li class="scroll-to-section"><a href="#our-classes">Packages</a></li>
                        <li class="scroll-to-section"><a href="#call-to-programs">Programs</a></li>
                        <li class="scroll-to-section"><a href="#schedule">Schedules</a></li>
                        <li class="scroll-to-section"><a href="#contact-us">Contact</a></li>
                        <li class="main-button"><a href="adminportal">Admin</a></li>
                    </ul>
                    <a class='menu-trigger'>
                        <span>Menu</span>
                    </a>
                    <!-- ***** Menu End ***** -->
                </nav>
            </div>
        </div>
    </div>
</header>
<!-- ***** Header Area End ***** -->

<!-- ***** Header Area End ***** -->

<!-- ***** Main Banner Area Start ***** -->
<div class="main-banner" id="top">
    <video autoplay muted loop id="bg-video">
        <source src="assets/images/gym-video.mp4" type="video/mp4"/>
    </video>

    <div class="video-overlay header-text">
        <div class="caption">
            <h6>Energize your desire with our gym</h6>
            <h2>Dare to be <em>Fit!</em></h2>
            <div class="main-button scroll-to-section">
                <a href="register.php">Become a member</a>
            </div>
        </div>
    </div>
</div>
<!-- ***** Main Banner Area End ***** -->

<!-- ***** Features Item Start ***** -->
<section class="section" id="services">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-3">
                <div class="section-heading">
                    <h2>Our <em>Services</em></h2>
                    <hr>
                    <img src="assets/images/line-dec.png" alt="waves">
                    <p>Bahria Active is your active lifestyle destination with excellent fitness and relaxation
                        amenities under one roof featuring the best gym, swimming pool, spa, steam, sauna &
                        cafe!</p>
                </div>
            </div>
            <div class="col-lg-6">
                <ul class="features-items">
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/features-first-icon.png" alt="First One">
                        </div>
                        <div class="right-content">
                            <h4>Top Class Gym</h4>
                            <p>Gymnasium is a large room with equipment for exercising the body and increasing strength
                                or a club where you can go to exercise and keep fit.</p>
                            <!-- <a href="#" class="text-button">Discover More</a> -->
                        </div>
                    </li>
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/swimming.png" alt="second one">
                        </div>
                        <div class="right-content">
                            <h4>Indoor Swimming Pool</h4>
                            <p>Pools are also used for other bathing activities, such as playing, wading, water
                                exercising</p>
                            <!-- <a href="#" class="text-button">Discover More</a> -->
                        </div>
                    </li>
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/Spa.png" alt="third gym training">
                        </div>
                        <div class="right-content">
                            <h4>Physio & Rehab</h4>
                            <p>Identifying and maximising quality of life and movement potential within the sphere of
                                promotion, prevention, intervention and rehabilitation</p>
                            <!-- <a href="#" class="text-button">Discover More</a> -->
                        </div>
                    </li>
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/Pilates.png" alt="third gym training">
                        </div>
                        <div class="right-content">
                            <h4>Pilates</h4>
                            <p>Pilates is a form of exercise which concentrates on strengthening the body with an
                                emphasis on core strength.</p>
                            <!-- <a href="#" class="text-button">Discover More</a> -->
                        </div>
                    </li>
                </ul>
            </div>
            <div class="col-lg-6">
                <ul class="features-items">
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/steam.png" alt="fourth muscle">
                        </div>
                        <div class="right-content">
                            <h4>Steam</h4>
                            <p>A steam room is a heated room that people use for relaxation and to relieve some medical
                                conditions. They are often found in gyms or spas.</p>
                            <!-- <a href="#" class="text-button">Discover More</a> -->
                        </div>
                    </li>
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/Suana.png" alt="training fifth">
                        </div>
                        <div class="right-content">
                            <h4>Sauna</h4>
                            <p>As the skin temperature rises, heavy sweating also occurs. The heart rate rises as the
                                body attempts to keep cool.</p>
                            <!-- <a href="#" class="text-button">Discover More</a> -->
                        </div>
                    </li>
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/cafe.png" alt="gym training">
                        </div>
                        <div class="right-content">
                            <h4>Cafe</h4>
                            <p>Energy Kitchen is the perfect place to grab a quick re-fuel after an intense exercise.
                                Serving up all kinds of healthy, immune boosting shakes </p>
                            <!-- <a href="#" class="text-button">Discover More</a> -->
                        </div>
                    </li>
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/GX-logo.png" alt="gym training">
                        </div>
                        <div class="right-content">
                            <h4>GX Studio</h4>
                            <p>Bahria Active offers a wide range of classes that include Yoga, Zumba, HIIT, LIFT, MMA Find out which classes suit your level of fitness and interest.</p>
                            <!-- <a href="#" class="text-button">Discover More</a> -->
                        </div>
                    </li>
            </div>
        </div>
    </div>
</section>
<!-- ***** Features Item End ***** -->

<!-- ***** Call to Action Start ***** -->
<section class="section" id="call-to-action">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 offset-lg-1">
                <div class="cta-content">
                    <h2>Don't <em>think</em>, begin <em>today</em>!</h2>
                    <p>Eat big. Lift big. Get big.</p>
                    <div class="main-button scroll-to-section">
                        <a href="register.php">Become a member</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ***** Call to Action End ***** -->

<!-- ***** Our Classes Start ***** -->
<section class="section" id="our-classes">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-3">
                <div class="section-heading">
                    <h2>Membership <em>Packages</em></h2>
                    <hr>
                    <img src="assets/images/line-dec.png" alt="">
                    <p>Become a member now</p>
                </div>
            </div>
        </div>
        <div class="row" id="tabs">
            <div class="col-lg-4">
                <ul>
                    <li class="scroll-to-section"><a href='#tabs-1'><img src="assets/images/individual.png" alt="">INDIVIDUAL</a>
                    </li>
                    <li class="scroll-to-section"><a href='#tabs-2'><img src="assets/images/couple.png" alt="">COUPLE/PARTNER/FRIEND</a>
                    </li>
                    <li class="scroll-to-section"><a href='#tabs-3'><img src="assets/images/family.png" alt="">FAMILY/GROUP(4
                            PERSONS)</a></a></li>
                    <li class="scroll-to-section"><a href='#tabs-4'><img src="assets/images/lifetime.png" alt="">LIFETIME(1 PERSON)</a>
                    </li>
                    <!-- <div class="main-rounded-button"><a href="#">View All Schedules</a></div> -->
                </ul>
            </div>
            <div class="col-lg-8">
                <section class='tabs-content'>
                    <article id='tabs-1'>
                        <img src="assets/images/header.jpg" id="scroll-to-section" alt="First Class">
                        <h4>INDIVIDUAL</h4>
                        <h6>MEMBERSHIP FEE<b> Rs.25,000/- </b></h6>
                        <br/>
                        <h6>QUARTERLY FEE<b> Rs.60,000/- </b></h6>
                        <br/>
                        <h6>SEMI ANNUAL FEE<b> Rs.95,000/- </b></h6>
                        <br/>
                        <h6>ANNUAL FEE<b> Rs.135,000/- </b></h6>
                        <br/>
                        <p>*This Package includes<b> Gym + Pool + Steam + Sauna</b></p>
                        <div class="main-button">
                            <!-- <a href="#">View Schedule</a> -->
                        </div>
                    </article>
                    <article id='tabs-2'>
                        <img src="assets/images/header.jpg" id="scroll-to-section" alt="Second Training">
                        <h4>COUPLE/PARTNER/FRIEND</h4>
                        <h6>MEMBERSHIP FEE<b> Rs.40,000/- </b></h6>
                        <br/>
                        <h6>QUARTERLY FEE<b> Rs.100,000/- </b></h6>
                        <br/>
                        <h6>SEMI ANNUAL FEE<b> Rs.160,000/- </b></h6>
                        <br/>
                        <h6>ANNUAL FEE<b> Rs.240,000/- </b></h6>
                        <br/>
                        <p>*This Package includes<b> Gym + Pool + Steam + Sauna</b></p>
                        <div class="main-button">
                            <!-- <a href="#">View Schedule</a> -->
                        </div>
                    </article>
                    <article id='tabs-3'>
                        <img src="assets/images/header.jpg" id="scroll-to-section" alt="Third Class">
                        <h4>FAMILY/GROUP(4 PERSONS)</h4>
                        <h6>MEMBERSHIP FEE<b> Rs.50,000/- </b></h6>
                        <br/>
                        <h6>QUARTERLY FEE<b> Rs.160,000/- </b></h6>
                        <br/>
                        <h6>SEMI ANNUAL FEE<b> Rs.255,000/- </b></h6>
                        <br/>
                        <h6>ANNUAL FEE<b> Rs.385,000/- </b></h6>
                        <br/>
                        <p>*This Package includes<b> Gym + Pool + Steam + Sauna</b></p>
                        <p>Kids below 5 years get <b>KIDS POOL FREE</b></p>
                        <div class="main-button">
                            <!-- <a href="#">View Schedule</a> -->
                        </div>
                    </article>
                    <article id='tabs-4'>
                        <img src="assets/images/header.jpg" id="scroll-to-section" alt="Fourth Training">
                        <h4>LIFETIME(1 PERSON)</h4>
                        <h6>MONTHLY SUBSCRIPTION<b> Rs.5,000/- </b></h6>
                        <br/>
                        <h6><b>20% OFF </b>ON PERSONAL TRAINING/PROGRAMS</h6>
                        <br/>
                        <h6><b>15% OFF </b>ON REHAB SERVICES</h6>
                        <br/>
                        <h6><b>15% OFF </b>ON CAFE</h6>
                        <br/>
                        <h6><b>1 DIET PLAN</b> Quarterly</h6>
                        <br/>
                        <h6>LIFETIME FEE<b> Rs.1,500,000/- </b></h6>
                        <br/>
                        <p>*This Package includes<b> Gym + Pool + Steam + Sauna</b></p>
                        <p>Kids below 5 years get <b>KIDS POOL FREE</b></p>
                        <div class="main-button">
                            <!-- <a href="#">View Schedule</a> -->
                        </div>
                    </article>
                </section>
            </div>
        </div>
    </div>
</section>
<!-- ***** Our Packages End ***** -->

<!-- Slider starts here -->
<div class="slideshow-container">
    <div class="mySlides">
        <div class="numbertext">1 / 4</div>
        <img alt="img-1" src="assets/slideshow/Sliders3.jpg" style="width:100%">
        <!--        <div class="text">Swimming Pool</div>-->
    </div>
    <div class="mySlides">
        <div class="numbertext">2 / 4</div>
        <img alt="img-2" src="assets/slideshow/Sliders.jpg" style="width:100%">
<!--        <div class="text">Gym</div>-->
    </div>
    <div class="mySlides">
        <div class="numbertext">3 / 4</div>
        <img alt="img-3" src="assets/slideshow/Sliders4.jpg" style="width:100%">
        <!--        <div class="text">Sauna</div>-->
    </div>
        <div class="mySlides">
            <div class="numbertext">4 / 4</div>
            <img src="assets/slideshow/Sliders5.jpg" style="width:100%">
<!--           <div class="text">Sauna</div>-->
        </div>
    <a class="prev" onclick="plusSlides(-1)">&#10094;</a>
    <a class="next" onclick="plusSlides(1)">&#10095;</a>
</div>
<br>
<div style="text-align:center">
    <span class="dot" onclick="currentSlide(1)"></span>
    <span class="dot" onclick="currentSlide(2)"></span>
    <span class="dot" onclick="currentSlide(3)"></span>
    <span class="dot" onclick="currentSlide(4)"></span>
</div>
<!-- Slider ends here -->

<!-- ***** Features Item Start ***** -->
<section class="section" id="features">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-3" id="call-to-programs">
                <div class="section-heading">
                    <h2>Fitness <em> Program</em></h2>
                    <hr>
                    <img src="assets/images/line-dec.png" alt="waves">
                    <p>Bahria Active is your active lifestyle destination with outstanding fitness and relaxation
                        amenities under one roof featuring the best gym, swimming pool, physio & rehab along with steam
                        & sauna</p>
                </div>
            </div>
            
            <!-- <div class="col-lg-6">
                <ul class="features-items">
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/features-first-icon.png" alt="First One">
                        </div>
                        <div class="right-content">
                            <h4>Weight Loss Training</h4>
                            <p>Gymnasium is a large room with equipment for exercising the body and increasing strength or a club where you can go to exercise and keep fit.</p>
                             <a href="#" class="text-button">Discover More</a>
                        </div>
                    </li>
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/features-first-icon.png" alt="second one">
                        </div>
                        <div class="right-content">
                            <h4>Strength Training</h4>
                            <p>. Pools are also used for other bathing activities, such as playing, wading, water exercising, floating on inner tubes, or cooling off on hot days.</p>
                             <a href="#" class="text-button">Discover More</a>
                        </div>
                    </li>
                </ul>
            </div>
            <div class="col-lg-6">
                <ul class="features-items">
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/features-first-icon.png" alt="fourth muscle">
                        </div>
                        <div class="right-content">
                            <h4>Kids Training Programs</h4>
                            <p>A steam room is a heated room that people use for relaxation and to relieve some medical conditions. They are often found in gyms or spas.</p>
                             <a href="#" class="text-button">Discover More</a>
                        </div>
                    </li>
                    <li class="feature-item">
                        <div class="left-icon">
                            <img src="assets/images/features-first-icon.png" alt="training fifth">
                        </div>
                        <div class="right-content">
                            <h4>Pre & Post Natal Exercise Program</h4>
                            <p>As the skin temperature rises, heavy sweating also occurs. The heart rate rises as the body attempts to keep cool.</p>
                        </div>
                    </li>
                </ul>
            </div> -->
        </div>
        <section class="section programs">
            <div class="container">
                <div class="row">
                    <div class="col-lg-10 offset-lg-1">
                        <div class="cta-content">
                            <div class="main-button">
                                <a href="assets/images/fitnessprogram.jpeg">Program Details</a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </div>
</section>
<!-- ***** Features Item End ***** -->

<!-- ***** Testimonials Ends ***** -->
<section class="section" id="schedule">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-3">
                <div class="section-heading dark-bg">
                    <h2>Gym <em>Schedule</em></h2>
                    <img src="assets/images/line-dec.png" alt="">
                    <p>Get in. Get Fit. Get on with Life.</p>
                </div>
            </div>
        </div>
        <div class="row">
            <div class="col-lg-12">
                <div class="filters">
                    <ul class="schedule-filter">
                        <li class="active" data-tsfilter="monday">Monday</li>
                        <li data-tsfilter="tuesday">Tuesday</li>
                        <li data-tsfilter="wednesday">Wednesday</li>
                        <li data-tsfilter="thursday">Thursday</li>
                        <li data-tsfilter="friday">Friday</li>
                    </ul>
                </div>
            </div>
            <div class="col-lg-10 offset-lg-1">
                <div class="schedule-table filtering">
                    <table>
                        <tbody>
                        <tr>
                            <td class="day-time">Power Hour(Females Only)</td>
                            <td class="monday ts-item show" data-tsmeta="monday">10:00AM</td>
                            <!-- <td class="monday ts-item show" data-tsmeta="monday"></td> -->
                            <td>Mahnoor</td>
                        </tr>
                        <tr>
                            <td class="day-time">Summer Shred(Females Only)</td>
                            <td class="monday ts-item show" data-tsmeta="monday">11:00AM</td>
                            <!-- <td class="thursday friday ts-item" data-tsmeta="thursday"> -->
                            </td>
                            <td>Dr. Sara Hamid</td>
                        </tr>
                        <tr>
                            <td class="day-time">Strength & Sweat(Females Only)</td>
                            <!-- <td class="tuesday ts-item" data-tsmeta="tuesday"></td> -->
                            <td class="monday ts-item show" data-tsmeta="monday">12:00PM</td>
                            <td>Nashmiya</td>
                        </tr>
                        <tr>
                            <td class="day-time">Koalas Fitness(Kids Only)</td>
                            <td class="monday ts-item show" data-tsmeta="monday">2:00PM</td>
                            <!-- <td class="friday ts-item" data-tsmeta="friday"></td> -->
                            <td>Nashmiya</td>
                        </tr>
                        <tr>
                            <td class="day-time">Power Pump(Mix)</td>
                            <td class="monday ts-item show" data-tsmeta="monday">5:00PM</td>
                            <!-- <td class="wednesday ts-item" data-tsmeta="wednesday"></td> -->
                            <td>Mujahid & Saqib</td>
                        </tr>
                        <tr>
                            <td class="day-time">Flab Fighters(Females Only)</td>
                            <!-- <td class="wednesday ts-item" data-tsmeta="wednesday"></td> -->
                            <td class="thursday ts-item show" data-tsmeta="monday">6:00PM</td>
                            <td>Hafsa</td>
                        </tr>
                        <tr>
                            <td class="day-time">Healthy Hustle(Mix)</td>
                            <td class="thursday ts-item show" data-tsmeta="monday">8:00PM</td>
                            <!-- <td class="wednesday ts-item" data-tsmeta="wednesday"></td> -->
                            <td>Dr. Akash</td>
                        </tr>
                        <tr>
                            <td class="day-time">Fitness 360(Mix)</td>
                            <!-- <td class="thursday ts-item" data-tsmeta="thursday"></td> -->
                            <td class="monday ts-item show" data-tsmeta="monday">9:00PM</td>
                            <td>Mujahid, Saqib & Akash</td>
                        </tr>
                        <tr>
                            <td class="day-time">Full Body HIIT(Males Only)</td>
                            <td class="thursday ts-item show" data-tsmeta="monday">10:00PM</td>
                            <!-- <td class="wednesday ts-item" data-tsmeta="wednesday"></td> -->
                            <td>Mujahid</td>
                        </tr>
                        <tr>
                            <td class="day-time">Pump & Burn(Males Only)</td>
                            <!-- <td class="thursday ts-item" data-tsmeta="thursday"></td> -->
                            <td class="monday ts-item show" data-tsmeta="monday">11:00PM</td>
                            <td>Awais</td>
                        </tr>
                        <tr>
                            <td class="day-time">Sweat it Out(Males Only)</td>
                            <!-- <td class="thursday ts-item" data-tsmeta="thursday"></td> -->
                            <td class="monday ts-item show" data-tsmeta="monday">12:00AM</td>
                            <td>Awais</td>
                        </tr>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- TRYING NEW -->

<!-- ***** Testimonials Starts ***** -->
<section class="section" id="trainers">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-3">
                <div class="section-heading">
                    <h2>Expert <em>Trainers</em></h2>
                    <img src="assets/images/line-dec.png" alt="">
                    <p>Trainers description.</p>
                </div>
            </div>
        </div>
        <section class="testimo">
    
            <div class="swiper mySwiper container">
                <div class="swiper-wrapper content">

                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                                <img src="assets/trainer-images/dr ramsha sohail-01.jpg" alt="">
                        </div>

                        <!-- <div class="media-icons">
                        <i class="fab fa-facebook"></i>
                        <i class="fab fa-twitter"></i>
                        </div> -->

                        <div class="name-profession">
                            <!-- <span class="name">Dr.Ramsha Sohail</span>
                            <span class="profession">Facility Head Bahria Active</span> -->
                            <ol class="discription">
                                <li>Sports Physiotherapy Specialist</li>
                                <li>Physiotherapist</li>
                                <li>7 years of experience</li>
                                <li>Pilates Expert</li>
                                <li>Initiated Hydrotherapy</li>
                            </ol>
                            
                            <!-- <span class="discription">Sports Physiotherapy Specialist</span> -->
                        </div>
                        <!-- 
                    <div class="rating">
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="fas fa-star"></i>
                    <i class="far fa-star"></i>
                    <i class="far fa-star"></i>
                    </div> -->

                    <!-- <div class="button">
                    <button class="aboutMe">About Me</button>
                    <button class="hireMe">Hire Me</button>
                    </div> -->
                </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/Dr. Sarah Khalid-01.jpg" alt="">
                        </div>
                        <div class="name-profession">
                            <!-- <span class="name">Dr.Sarah Khalid</span>
                            <span class="profession">Floor Manager & Rehab Expert</span> -->
                            <ol class="discription">
                                <li>Physical Therapist</li>
                                <li>Highly Qualified</li>
                                <li>Specialized in the treatment of</li>
                                    <ul>
                                        <li>Musculoskeletal disorders</li>
                                        <li>Neurological Disorders</li>
                                        <li>Spinal Cord Injuries</li>
                                        <li>Hydrotherapy</li>
                                    </ul>
                                </ol>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/Dr. Sara Hamid-01.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Dr.Sara Hamid</span>
                            <span class="profession">Fitness Expert</span> -->
                            <ol class="description">
                                <li>Bodywieght & Strength Training</li>
                                <li>Fatloss & Body Toning</li>
                                <li>Aerobics & Stretching Expert</li>
                                <li>Physiotherapist</li>
                                <li>Pilates Instructor</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/Arshad Mehmood-01.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Arshad Mehmood</span>
                            <span class="profession">Swimming Instructor</span> -->
                            <ol class="description">
                                <li>Ex-Pakistan Navy Serviceman</li>
                                <li>20+ Years Of Experience</li>
                                <li>Trained Several Officers & Sailors</li>
                                <li>Worked in Pakistan Naval Academy</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/Ajaz Ahmed-01.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Ajaz Ahmed</span>
                            <span class="profession">Swimming Instructor</span> -->
                            <ol class="description">
                                <li>Ex-Pakistan Navy Serviceman</li>
                                <li>22+ Years Of Experience</li>
                                <li>Expertise in swimming techniques</li>
                                <li>Has trained foreign Cadets & Officers</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/Shezrae Arslan Gillani-01.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Shezrae Arslan Gillani</span>
                            <span class="profession">Swimming Instructor</span> -->
                            <ol class="description">
                                <li>Analyizing Swim Techniques</li>
                                <li>Determining Skill Levels</li>
                                <li>Overseeing Training</li>
                                <ul>
                                    <li>Developing Individualized Swimming Programs</li>
                                    <li>Educating swimmers on various techniques & styles</li>
                                </ul>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/Ahsan Mehmood-01.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Ahsan Mehmood</span>
                            <span class="profession">Swimming Instructor</span> -->
                            <ol class="description">
                                <li>Result-Oriented & Curteous</li>
                                <li>Weight Management Expert</li>
                                <li>Specializes in:</li>
                                <ul>
                                    <li>Zumba</li>
                                    <li>Weight Training</li>
                                </ul>
                                
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/Dr. Akash Arish-01.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Dr.Akash Arish</span>
                            <span class="profession">Pilates & Rehab Expert</span> -->
                            <ol class="description">
                                <li>Uses Various Therapeutic Techniques</li>
                                <li>Physiotherapist</li>
                                <li>Specialized in the treatment of:</li>
                                <ul>
                                    <li>Orthopedic Injuries</li>
                                    <li>Sports Injuries</li>
                                    <li>Musculoskeletal Injuries</li>
                                    <li>Hydrotherapy</li>
                                </ul>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/mujahid ul islam hashmi-01.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Dr.mujahid Arish</span>
                            <span class="profession">Pilates & Rehab Expert</span> -->
                            <ol class="description">
                               <li>Group Classes</li>
                               <li>Weight Management</li>
                               <li>Crossfitt</li>
                               <li>Stretching</li>
                               <li>Body Conditioning</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/Awais Khan Afridi-01.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Awais Khan Afridi</span>
                            <span class="profession">Boot Camp Transforamtion</span> -->
                            <ol class="description">
                               <li>Circuit training & HIIT Cardio</li>
                               <li>Fat loss & Body Toning</li>
                               <li>Mobility & Agility Training</li>
                               <li>Stretching</li>
                               <li>Conditioning Training</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/mahnoor.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Mahnoor</span>
                            <span class="profession">Boot Camp Transforamtion</span> -->
                            <ol class="description">
                               <li>Cardio, Strength, HIIT Trainer</li>
                               <li>Fatloss & Body Toning</li>
                               <li>Certified Fitness Coach</li>
                               <li>Certified Athlete</li>
                               <li>Weightloss Transformational Partner</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/nashmiya.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Nashmiya</span>
                            <span class="profession">Boot Camp Transforamtion</span> -->
                            <ol class="description">
                               <li>Strength Training</li>
                               <li>Core & Balance Training</li>
                               <li>Pilates Expert</li>
                               <li>Yoga Instructor</li>
                               <li>Active Kids Trainer</li>
                            </ol>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide card">
                    <div class="card-content">
                        <div class="image">
                            <img src="assets/trainer-images/saqib.jpg" alt="">
                        </div>

                        <div class="name-profession">
                            <!-- <span class="name">Saqib</span>
                            <span class="profession">Boot Camp Transforamtion</span> -->
                            <ol class="description">
                               <li>Model Physic</li>
                               <li>Specialist Weight & Cardio Training</li>
                               <li>Certified PBBF & PSB</li>
                            </ol>
                        </div>
                    </div>
                </div>

            </div>
            </div>

      <div class="swiper-button-next"></div>
      <div class="swiper-button-prev"></div>
      <div class="swiper-pagination"></div>
  </section>
    </div>
    
    <br/><br/><br/><br/><br/>
</section>
<!-- ***** Testimonials Ends ***** -->

<!-- ***** NEWS & EVENTS Starts ***** -->
<section class="section" id="events">
    <div class="container">
        <div class="row">
            <div class="col-lg-6 offset-lg-3">
                <div class="section-heading">
                    <h2 class="newsheading">NEWS & <em>EVENTS</em></h2>
                    <img src="assets/images/line-dec.png" alt="">
                    <!-- <p class="newsheading">Our Gallery</p> -->
                </div>
            </div>
        </div>
        <section class="newsevent">
    
            <div class="swiper mySwiper2 container">
                <div class="swiper-wrapper content">

                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                                <a href= "assets/news/News1.jpeg"><img src="assets/news/News1.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News2.jpeg"><img src="assets/news/News2.jpeg" alt=""></a>
                        </div>   
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News3.jpeg"><img src="assets/news/News3.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News4.jpeg"><img src="assets/news/News4.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News5.jpeg"><img src="assets/news/News5.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News6.jpeg"><img src="assets/news/News6.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News7.jpeg"><img src="assets/news/News7.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News8.jpeg"><img src="assets/news/News8.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News9.jpeg"><img src="assets/news/News9.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News10.jpeg"><img src="assets/news/News10.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News11.jpeg"><img src="assets/news/News11.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News12.jpeg"><img src="assets/news/News12.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>
                <div class="swiper-slide news">
                    <div class="news-content">
                        <div class="image">
                            <a href="assets/news/News13.jpeg"><img src="assets/news/News13.jpeg" alt=""></a>
                        </div>
                    </div>
                </div>

            </div>
            </div>

      <div class="swiper-button-next"></div>
      <div class="swiper-button-prev"></div>
      <div class="swiper-pagination"></div>
  </section>
  <br/><br/><br/><br/><br/>
    <br/><br/><br/><br/><br/>
    </div>
</section>
<!-- ***** NEWS & EVENTS Ends ***** -->

<!-- ***** Contact Us Area Starts ***** -->
<section class="section" id="contact-us">
    <div class="container-fluid">
        <div class="row">
            <div class="col-lg-6 col-md-6 col-xs-12">
                <div id="map">
                    <!--                    <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d13298.009334562325!2d73.1169131!3d33.5663044!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0xf6ebe69f395673a7!2sBahria%20Active!5e0!3m2!1sen!2s!4v1646611975815!5m2!1sen!2s" width="600" height="450" style="border:0;" allowfullscreen="" loading="lazy"></iframe>-->
                    <!-- <iframe src="" width="600px" height="100%" style="border:0;" allowfullscreen loading="lazy"></iframe> -->
                    <iframe src="https://www.google.com/maps/embed?pb=!1m14!1m8!1m3!1d13298.009334562325!2d73.1169131!3d33.5663044!3m2!1i1024!2i768!4f13.1!3m3!1m2!1s0x0%3A0xf6ebe69f395673a7!2sBahria%20Active!5e0!3m2!1sen!2s!4v1646611975815!5m2!1sen!2s"
                            width="100%" height="830px" style="border:0" allowfullscreen></iframe>
                </div>
            </div>
            <div class="col-lg-6 col-md-6 col-xs-12">
                <div class="contact-form">
                    <form id="contact" action="" method="post">
                        <h5>Contact Us</h5>
                        <br/>
                        <div class="row">
                            <div class="col-md-6 col-sm-12">
                                <fieldset>
                                    <input name="name" type="text" id="name" placeholder="Your Name*" required="">
                                </fieldset>
                            </div>
                            <div class="col-md-6 col-sm-12">
                                <fieldset>
                                    <input name="email" type="text" id="email" pattern="[^ @]*@[^ @]*"
                                           placeholder="Your Email*" required="">
                                </fieldset>
                            </div>
                            <div class="col-md-12 col-sm-12">
                                <fieldset>
                                    <input name="subject" type="text" id="subject" placeholder="Subject">
                                </fieldset>
                            </div>
                            <div class="col-lg-12">
                                <fieldset>
                                    <textarea name="message" rows="6" id="message" placeholder="Message"
                                              required=""></textarea>
                                </fieldset>
                            </div>
                        </div>
                        
                        <div class="row">
                            <!-- Facebook -->
                            <div class="socialmedia">
                                <a href="https://www.facebook.com/Bahria-Active-106501908555505" ><img class="socialmedia-logo" src="images/icons/facebook.png"></a>
                                <p class="socialmedia-description">bahriaactive</p>
                            </div>
                            <!-- Instagram -->
                            <div class="socialmedia">
                                <a href="https://www.instagram.com/bahriaactive_bt/?utm_medium=copy_li+nk"><img class="socialmedia-logo" src="images/icons/instagram.png"></a>
                                <p class="socialmedia-description">bahriaactivebt</p>
                            </div>
                            <!-- Whatsapp -->
                            <div class="socialmedia">
                                <a href="https://api.whatsapp.com/send/?phone=923312777846&text&app_absent=0"><img class="socialmedia-logo" src="images/icons/whatsapp.png"></a>
                                <p class="socialmedia-description">03312777846</p>
                            </div class="socialmedia">
                            <!-- Telephone -->
                            <div class="socialmedia">
                                <a href="tel:+920515911111"><img class="socialmedia-logo" src="images/icons/telephone-call.png"></a>
                                <p class="socialmedia-description">+92 (51) 5911111</p>
                            </div>
                            <!-- Email -->
                            <div class="socialmedia">
                                <a href="mailto:info@bahriaactive.com"><img class="socialmedia-logo" src="images/icons/email.png"></a>
                                <p class="socialmedia-description">info@bahriaactive.com</p>
                            </div>
                            
                            <br/><br/>
                        </div>
                        <div>
                        
                        <div class="g-recaptcha validate-input input-address" id="rcaptcha"
                             data-sitekey="6LdpQNQeAAAAAHuWj2d5cnZIKPLI2iYK3fZqFSSW" required></div>
                        <!--                    website-->
                        <!--                    <div class="g-recaptcha validate-input input-address" id="rcaptcha"-->
                        <!--                         data-sitekey="6LdpQNQeAAAAAHuWj2d5cnZIKPLI2iYK3fZqFSSW" required></div>-->
                        <span id="captcha" style="color:red">
					</span> <!-- this will show captcha errors -->
                        <br/><br/>
                        <div class="col-lg-12">
                            <fieldset>
                                <button type="submit" id="form-submit" class="main-button">Send Message</button>
                            </fieldset>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- ***** Contact Us Area Ends ***** -->

<!-- ***** Footer Start ***** -->
<footer>
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <p>Copyright &copy; <?php echo date("Y"); ?> Bahria Active

                    - Designed by <a rel="nofollow" href="https://tst.com.pk" class="tm-text-link" target="_parent">TotalSoft</a>
                </p>

            </div>
        </div>
    </div>
</footer>

<!-- jQuery -->
<script src="assets/js/jquery-2.1.0.min.js"></script>

<!-- Bootstrap -->
<script src="assets/js/popper.js"></script>
<script src="assets/js/bootstrap.min.js"></script>

<!-- Plugins -->
<script src="assets/js/scrollreveal.min.js"></script>
<script src="assets/js/waypoints.min.js"></script>
<script src="assets/js/jquery.counterup.min.js"></script>
<script src="assets/js/imgfix.min.js"></script>
<script src="assets/js/mixitup.js"></script>
<script src="assets/js/accordions.js"></script>
<script src="assets/js/swiper-bundle.min.js"></script>

<script src='https://www.google.com/recaptcha/api.js'></script>
<!-- Global Init -->
<script src="assets/js/custom.js"></script>
<script>
    function get_action(form) {
        var v = grecaptcha.getResponse();
        if (v.length == 0) {
            document.getElementById('captcha').innerHTML = "You can't leave Captcha Code empty";
            return false;
        } else {
            document.getElementById('captcha').innerHTML = "Captcha completed";
            return true;
        }
    }
</script>

  <!-- Swiper JS -->
  <!-- <script src="https://unpkg.com/swiper/swiper-bundle.min.js"></script> -->
  <!-- Initialize Swiper -->
  <script>
    var swiper = new Swiper(".mySwiper", {
      slidesPerView: 3,
      spaceBetween: 30,
      slidesPerGroup: 1,
      loop: true,
      autoplay:true,
      loopFillGroupWithBlank: true,
      pagination: {
        el: ".swiper-pagination",
        clickable: true,
      },
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
    });


    var swiper2 = new Swiper(".mySwiper2", {
      slidesPerView: 2,
      spaceBetween: 30,
      slidesPerGroup: 1,
      loop: true,
      autoplay:true,
      loopFillGroupWithBlank: true,
      pagination: {
        el: ".swiper-pagination",
        clickable: true,
      },
      navigation: {
        nextEl: ".swiper-button-next",
        prevEl: ".swiper-button-prev",
      },
    });
    
  </script>

</body>
</html>